/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class Comparators {
    private static Comparator naturalComparator;

    public static int compare(long l1, long l2) {
        return l1 < l2 ? -1 : (l1 == l2 ? 0 : 1);
    }

    public static int compare(int i1, int i2) {
        return i1 < i2 ? -1 : (i1 == i2 ? 0 : 1);
    }

    public static int compare(double d1, double d2) {
        return d1 < d2 ? -1 : (d1 == d2 ? 0 : 1);
    }

    public static int compare(boolean x, boolean y) {
        return x == y ? 0 : (x ? 1 : -1);
    }

    public static int compare(double d1, double d2, double precision) {
        if (Math.abs(d1 - d2) < precision) {
            return 0;
        }
        return Comparators.compare(d1, d2);
    }

    public static boolean equals(double d1, double d2, double precision) {
        return Comparators.compare(d1, d2, precision) == 0;
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static <T extends Comparable<? super T>> Comparator<T> naturalComparator() {
        if (naturalComparator == null) {
            naturalComparator = new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return o1.compareTo(o2);
                }
            };
        }
        return naturalComparator;
    }

    public static <T extends Comparable<? super T>> Comparator<T> naturalUniqueComparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int res = o1.compareTo(o2);
                if (res == 0) {
                    res = Comparators.compare(System.identityHashCode(o1), System.identityHashCode(o2));
                }
                return res;
            }
        };
    }

    public static <T> Comparator<T> getJointComparator(final Iterable<Comparator<T>> comps) {
        if (comps == null || !comps.iterator().hasNext()) {
            return null;
        }
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                for (Comparator c : comps) {
                    int partialComparison = c.compare(o1, o2);
                    if (partialComparison == 0) continue;
                    return partialComparison;
                }
                return 0;
            }
        };
    }

    public static <T> Comparator<List<T>> listComparator(final Comparator<? super T> elementComparator) {
        Preconditions.checkNotNull(elementComparator);
        return new Comparator<List<T>>(){

            @Override
            public int compare(List<T> o1, List<T> o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                Iterator i1 = o1.iterator();
                Iterator i2 = o2.iterator();
                int res = 0;
                while (res == 0 && i1.hasNext() && i2.hasNext()) {
                    res = elementComparator.compare(i1.next(), i2.next());
                }
                if (res == 0 && (i1.hasNext() || i2.hasNext())) {
                    res = i1.hasNext() ? 1 : -1;
                }
                return res;
            }
        };
    }

    public static <T extends Comparable<? super T>> int compareNullsLast(@Nullable T o1, @Nullable T o2) {
        if (o1 != null) {
            if (o2 != null) {
                return o1.compareTo(o2);
            }
            return -1;
        }
        if (o2 != null) {
            return 1;
        }
        return 0;
    }
}

